clear all
%that is waveguide with point converter

disp('started')

 global MainWidth InLineWidth InLineGapWidth ConverterWidth ConverterLength ConnectorLength
 
k=0.8;   %points per nm   0.08 in case mode 4 and 0.8 in normal mode
%
    InLineWidth=30*k;  %30
    InLineGapWidth=35*k; % 35
    ReverseObject='n'; % when problem with inline
%}


SaveToFile=true; myPath='E:\AMATLAB\reticle\';MyFile='';
AutoFileName=false;MyFile0='SiWave4'; if ~AutoFileName; MyFile='';end
MyJob='sw';  % 'sw' 'strait waveguide with converted  272
             % 'rn'  ' ring resonator            397
              % 'cw' curved waveguide with convertor
              % 'ss'   spot size convertor       360
              % 'pl    polarizer
              %  'ci    coupled isolator; only waveg no inset
              %   mz  mach zender interferometer
              %   sn    snake waveguide
              % sr     snake road waveguide
              %s1 one side splitter to test ring resonator
              %
 %jL=[0 2 4 8 16 32 64];   % plasmon length
 %jL=[2 4 8 16 32 ];   % plasmon length
 jL=0.01;   % plasmon length
 
 
          
%%%%%%%%%%%%%%%%%% spot size convertter   
%MainWidth=180*k;
%main
    %
     MainWidth=400*k; % 450*k; % nm 
    MainLength=  3900*1000*k;  % total length
    ConverterWidth=150*k  ;%200*k;  % 
    ConverterLength=350*1000*k; % in nm  
    ConnectorLength=350*1000*k; % in nm  350/2 general
    %}
%narrow plasmons
    %{
     MainWidth=180*k; % 450*k; % nm 
    MainLength=  3900*1000*k;  % total length
    ConverterWidth=150*k  ;%200*k;  %5000 
    ConverterLength=350*1000*k; % in nm  
    ConnectorLength=350/2*1000*k; % in nm
    %}


    %{
     MainWidth=180*k; % 450*k; % nm 
    MainLength=  3900*1000*k;  % total length
    ConverterWidth=150*k  ;%200*k;  %5000 
    ConverterLength=350*1000*k; % in nm  
    ConnectorLength=350/2*1000*k; % in nm
    %}
    %{

    % used for GaAs converssion
     MainWidth=1800*k; % 450*k; % nm 
    MainLength=  3900*1000*k;  % total length
    ConverterWidth=4000*k  ;%200*k;  %5000 
    ConverterLength=350*1000*k; % in nm  
    ConnectorLength=350/2*1000*k; % in nm
    %}
%{
%  converter
     MainWidth=1500*k; % 450*k; % nm 
    MainLength=  400*1000*k;  % total length
    ConverterWidth=3000*k  ;%200*k;  %5000 
    ConverterLength=0.4*1000*k; % in nm  
    ConnectorLength=0.4/2*1000*k; % in nm
%}
    %SEM
     %{
     MainWidth= 600*k; % nm 
    MainLength=  400*1000*k;  % total length
    ConverterWidth=800*k;  %5000 
    ConverterLength=50*1000*k; % in nm  
    ConnectorLength=50*1000*k; % in nm
     %}
    
  
%
    %plasmonic part of side converter
     %{
     gapWas=550*k;   % for GaAs 800*k; 
     waveWidthWas=450*k;   %   for GaAs 1800*k;
     waveCoupledLen=10*1000*k;
     GapPlasmon=100*k;  %Si 100/200 % GaAs 500*k; 900*k GaAs small
     MainWidth= (gapWas+ waveWidthWas)-2*GapPlasmon;
    
    ConverterWidth=150*k;  %5000 
    ConverterLength=4000*k; % in nm  
    ConnectorLength=MainWidth/waveWidthWas*waveCoupledLen; % in nm
    MainLength=  jL*1000*k+2*ConverterLength+2*ConnectorLength;  % total length
    jL=0;
    disp([' need offset: ' num2str(gapWas/2+waveWidthWas/2)])
     %}
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 
    PlasmonPosition(1)= MainLength/2-1100*1000*k; %for straight ??????
    %PlasmonPosition(1)=0;
    %PlasmonPosition(1)=MainLength-1100*1000*k; %that is position of plasmons relatively to right edge of waveguide
    PlasmonPosition(2)=0*1000*k;
    disp(['plasmon position from left= ' num2str(PlasmonPosition(1)/k/1000) ' um'])
    
    PlasmonLength=jL*1000*k; % more than 0 than break at plasmon

    CenterToLeft=2700*k*1000;   %500*k*1000; % um  %that is length from EB pattern center to left edge of converter
    
 
  
    LeftSpotSizeConverter=true;
    RightSpotSizeConverter=true;
    
%%%%%%%%%%%%%%%%%%%%%
if strcmp(MyJob,'sw')  %  'strait waveguide with converted
           
    ReverseInline=true;
    ReverseMain=true;
end

%%%%%%%%%%%%%%%%%%%%%
if strcmp(MyJob,'pl')  %  'two waveguide with polarizer and plasmon
         gap=280*k;  % nm
          MyInteractionLen=20*k*1000; % um

 
   PolarizerPosition=500*k*1000; % um  %that is possition of polarizer in respect to left edge of converter        
            
  BendAngle=20;  % deg
       
  BendRadius=80*k*1000;  %um 
           WaveDistance=100*k*1000;  % not yet working   um distance between waveguide  
 

      
     StraightDistance=10*k*1000;
      
    
  
end
%%%%%%%%%%%%%%% Mach-Zender
if strcmp(MyJob,'mz')
        gap=200*k;
     % splitters (should be the same for input and output)
    Split_intrLen=6*1000*k;  %um Si1 6 um Si2  5 um   Si3 7 um
    Split_R=50*1000*k;
    Split_BendAngle=20;
    Split_Short=1*k*1000;  % short connection distance
    
    MZLen= 200*k*1000;  % um  length of straight part of interferometer
   
    % before input splitter
    BeforeSplitter=10*k*1000;
    AfterInterferometer=10*k*1000;
    
    ShortArm=1*k*1000;
end

 %%%%%%%%%%%%%%%%%%%%%%%%%%  ring resonator
if strcmp(MyJob,'rn') 
     el_size=(250-0.001*(450-180))*1000*k; % external radius
     el_ratio=1; 
 
         MyInteractionLen=16*k*1000;%   ringA 40*k*1000;
         PlasmonPosition(1)=0;
         MakePlasmon=true;
    
end
 %%%%%%%%%%%%%%%%%%%%%%%%%%  spot-size onverter
if strcmp(MyJob,'ss') 
    

         big_size=5*1000*k; 
      big_length=ConverterLength; 
      small_size=150*k; 
      between_length=ConnectorLength;
end
 %%%%%%%%%%%%%%%%%%%%%%%%%%  curved waveguide
if strcmp(MyJob,'cw') 
    BendRadius1=250*1000*k; %nm
    BendAngle=45;
    
    BeforeLength=1000*1000*k; % old 1000  for longer 850
    MiddleLength=100*1000*k;  % old 100 um
       
    CurvedSraight=380*1000*k; % old 10 and 1000
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%  coupled isolator
if strcmp(MyJob,'ci')
    coupledLen=10*1000*k; %um
    waveguideOffset=MainWidth+800*k; %um
    
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    snake waveguide
if strcmp(MyJob,'sn')  %  using 50/50 spliters
      SnakeDiameter=40*k*1000;
      SnakeNumber=12; 
    
    ConnectionDistance=0.1*k*1000;
    BeforeSplitter=50*k*1000;
    DistanceBetween=5*k*1000;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    make snake road waveguide
if strcmp(MyJob,'sr')  %  using 50/50 spliters
      SnakeDiameter=200*k*1000;
      SnakeNumber=1; 
    
      BeforeSplitter=50*k*1000;
      
      SnakeLength=2500*1E3*k;
end   
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    make one side splitter  (to test a ring resonator)
if strcmp(MyJob,'s1')  % 
    MyDiameter=250*k*1000;
    InteractionLen=0.1*k*1000;
    MyYShift=50*k*1000;
    BeforeSplitter=50*k*1000;
    BetweenDistance=0.5*k*1000;
end
  

%%%%%%%%%%%%%%% making
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%    make one side splitter  (to test a ring resonator)
if strcmp(MyJob,'ss1')  % 
    
    % xstep=R*sin(angle)
    % ystep=R*(1-cos(angle))
    % dy=2*R*(1-cos(angle))    1-dy/(2R)=cos(alfa)

    MyRadius=MyDiameter/2;
    
    MyCos=1-MyYShift/2/MyRadius;MySin=sqrt(1-MyCos^2);
    MyAngle=asin(MySin)/pi*180;
    
   j=0;
     j=j+1;Curved(:,j)=[BeforeSplitter MyRadius MyAngle];
     j=j+1;Curved(:,j)=[BetweenDistance MyRadius -MyAngle];
     j=j+1;Curved(:,j)=[InteractionLen MyRadius -MyAngle];
     j=j+1;Curved(:,j)=[BetweenDistance MyRadius MyAngle];
     
   
    
     AfterLength=MainLength-(BeforeSplitter+2*BetweenDistance*sin(MyAngle*pi/180)+2*MyRadius*MySin+2*(ConverterLength+ConnectorLength));
    
     
     
     LeftSpotSizeConverter=true; RightSpotSizeConverter=true;
       MakeCurvedWaveguide=false;
     Symmetrical=false;  %
     IsMax=false;
    InverseMe=false;  %
    
   
    [AllObjects TotalLength1 EndPoint1 MaxY1 MinY1]=CurevedWaveguide(Curved, AfterLength,LeftSpotSizeConverter, RightSpotSizeConverter);
     disp(['y top= ' num2str((-MinY1+MainWidth/2)/k)]);
     %disp(['additional length= ' num2str((2*SnakeNumber*(SnakeLength+pi*SnakeRadius))/k)]);
     
     ObjectToProcess=AllObjects;
    MyShiftX=-1.95*k*1E6;
    ReverseMeY=false;MyOffsetX=MyShiftX;MyOffsetY=0;
    for j=1:length(ObjectToProcess)
         ObjectToProcess(j).MyObj(:,1)=ObjectToProcess(j).MyObj(:,1)+MyOffsetX;
         if ReverseMeY
             ObjectToProcess(j).MyObj(:,2)=-ObjectToProcess(j).MyObj(:,2)+MyOffsetY;
         else
             ObjectToProcess(j).MyObj(:,2)=ObjectToProcess(j).MyObj(:,2)+MyOffsetY;
         end           
    end
    AllObjects=ObjectToProcess; clear ObjectToProcess; 
     
     
    
end






    GenerateWaveguide2       
    






%%%%%%%%%%%%%%%%%%%%%%
    if AutoFileName
        
        if jL(jjL)>0
        MyFile=[MyFile0 'P' num2str(jL(jjL)) 'um.j01'];
        
        else
        MyFile=[MyFile0 '.j01' ];
        end
    end
    
    MyCenterPosition=PlasmonPosition;
    
rawPlotting=false;  % this will plot without resizing
StandartProcessing
clear AllObjects1;
   
 
   
   
 
 